<?php

/**
 * @var \Laravel\Lumen\Routing\Router $router
 *  @var \Illuminate\Foundation\Application $app
 */


use App\Modules\Tour\Domain\TourRepository;
use App\Modules\Tour\Infraestructure\MysqlTourRepository;

$app->bind(TourRepository::class, fn($app) => $app->make(MysqlTourRepository::class));

$router->put(
    '/tour/copyQuestions',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Tour\\CopyQuestions@__invoke'
    ]
);

$router->get(
    '/tour',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Tour\\TourListController@__invoke'
    ]
);
