<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;
use App\Modules\ReviewNotification\Infraestructure\MysqlReviewNotificationRepository;

$app->bind(ReviewNotificationRepository::class, fn($app) => $app->make(MysqlReviewNotificationRepository::class));

$router->post(
    '/reviewNotification',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationInsertController@__invoke'
    ]
);

$router->post(
    '/reviewNotification/{Id}/reply',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationReplyController@__invoke'
    ]
    )->where(['Id' => '[0-9]*']);

$router->put(
    '/reviewNotification',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationUpdateController@__invoke'
    ]
);

$router->put(
    '/reviewNotification/accept',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationAcceptController@__invoke'
    ]
);

$router->delete(
    '/reviewNotification/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/reviewNotification/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/groupPassenger/{IdGroupPassenger}/reviewNotification/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ReviewNotification\\ReviewNotificationListController@__invoke'
    ]
)->where('IdGroupPassenger', '[0-9]*');
