<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Provider\Domain\ProviderRepository;
use App\Modules\Provider\Infrastructure\MysqlProviderRepository;

$app->bind(ProviderRepository::class, fn ($app) => $app->make(MysqlProviderRepository::class));

$router->post(
    '/provider',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@Insert'
    ]
);
$router->post(
    '/provider/update',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@Update'
    ]
);
$router->delete(
    '/provider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@Delete'
    ]
);

$router->get(
    '/provider/score/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider\\ProviderListScoreController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/provider/review',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@ListReview'
    ]
);

$router->get(
    '/provider/service',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@ListServices'
    ]
);

$router->get(
    '/provider/service/excel',
    [
        'uses' => 'Provider@ListServicesExcel'
    ]
);

$router->get(
    '/provider/searchWithSanction',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@SearchWithSanction'
    ]
);

$router->get(
    '/provider/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Provider@Selector'
    ]
);
