<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;
use App\Modules\LeadPassenger\Infraestructure\MysqlLeadPassengerRepository;

$router->post(
    '/leadPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadPassenger\\LeadPassengerInsertController@__invoke'
    ]
);

$router->put(
    '/leadPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadPassenger\\LeadPassengerUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadPassenger\\LeadPassengerDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadPassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadPassenger\\LeadPassengerIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/leadBooking/{Id_Booking}/leadPassenger/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadPassenger\\LeadPassengerListController@__invoke'
    ]
)->where('Id_Booking', '[0-9]*');

$app->bind(LeadPassengerRepository::class, fn($app) => $app->make(MysqlLeadPassengerRepository::class));
