<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Lead\Domain\LeadRepository;
use App\Modules\Lead\Infraestructure\MysqlLeadRepository;

$app->bind(LeadRepository::class, fn($app) => $app->make(MysqlLeadRepository::class));

$router->post(
    '/lead',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadInsertController@__invoke'
    ]
);

$router->put(
    '/lead',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadUpdateController@__invoke'
    ]
);

$router->delete(
    '/lead/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/lead/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/lead/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Lead\\LeadListController@__invoke'
    ]
);
