<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedRepository;
use App\Modules\HtlTypeRoomBed\Infrastructure\MysqlHtlTypeRoomBedRepository;

$app->bind(HtlTypeRoomBedRepository::class, fn ($app) => $app->make(MysqlHtlTypeRoomBedRepository::class));

$router->post(
    '/htlTypeRoomBed',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoomBed\\HtlTypeRoomBedInsertController@__invoke'
    ]
);

$router->put(
    '/htlTypeRoomBed',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoomBed\\HtlTypeRoomBedUpdateController@__invoke'
    ]
);

$router->get(
    '/htlTypeRoomBed/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoomBed\\HtlTypeRoomBedIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlTypeRoom/{IdHtlTypeRoom}/htlTypeRoomBed/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoomBed\\HtlTypeRoomBedListController@__invoke'
    ]
);

$router->delete(
    '/htlTypeRoomBed/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoomBed\\HtlTypeRoomBedDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
