<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlCampBooking\Domain\HtlCampBookingRepository;
use App\Modules\HtlCampBooking\Infrastructure\MysqlHtlCampBookingRepository;

$app->bind(HtlCampBookingRepository::class, fn ($app) => $app->make(MysqlHtlCampBookingRepository::class));

$router->get(
    '/bookingTour/{Id_BookingTour}/htlCampBooking/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBooking\\HtlCampBookingListController@__invoke'
    ]
)->where('Id_BookingTour', '[0-9]*');

$router->get(
    '/htlCampBooking/{Id_HtlCampBooking}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBooking\\HtlCampBookingIndexController@__invoke'
    ]
)->where('Id_HtlCampBooking', '[0-9]*');

$router->post(
    '/htlCampBooking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBooking\\HtlCampBookingInsertController@__invoke'
    ]
);

$router->put(
    '/htlCampBooking',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBooking\\HtlCampBookingUpdateController@__invoke'
    ]
);

$router->delete(
    '/htlCampBooking/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampBooking\\HtlCampBookingDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

