<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlBed\Domain\HtlBedRepository;
use App\Modules\HtlBed\Infrastructure\MysqlHtlBedRepository;

$app->bind(HtlBedRepository::class, fn ($app) => $app->make(MysqlHtlBedRepository::class));

$router->post(
    '/htlBed',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlBed\\HtlBedInsertController@__invoke'
    ]
);

$router->put(
    '/htlBed',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlBed\\HtlBedUpdateController@__invoke'
    ]
);

$router->get(
    '/htlBed/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlBed\\HtlBedIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/htlBed/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlBed\\HtlBedListController@__invoke'
    ]
);

$router->delete(
    '/htlBed/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlBed\\HtlBedDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
