<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaRepository;
use App\Modules\GroupProviderMedia\Infrastructure\MysqlGroupProviderMediaRepository;
use App\Modules\Media\Domain\FileReceptor;
use App\Modules\Media\Domain\ImageThumbnailCreator;
use App\Modules\Media\Domain\MediaRepository;
use App\Modules\Media\Domain\VideoThumbnailCreator;
use App\Modules\Media\Infrastructure\LaravelFileReceptor;
use App\Modules\Media\Infrastructure\MemoryImageThumbnailCreator;
use App\Modules\Media\Infrastructure\MemoryMediaRepository;
use App\Modules\Media\Infrastructure\MemoryVideoThumbnailCreator;

$app->bind(MediaRepository::class, fn ($app) => $app->make(MemoryMediaRepository::class));
$app->bind(GroupProviderMediaRepository::class, fn ($app) => $app->make(MysqlGroupProviderMediaRepository::class));
$app->bind(VideoThumbnailCreator::class, fn ($app) => $app->make(MemoryVideoThumbnailCreator::class));
$app->bind(ImageThumbnailCreator::class, fn ($app) => $app->make(MemoryImageThumbnailCreator::class));
$app->bind(FileReceptor::class, fn ($app) => $app->make(LaravelFileReceptor::class));

$router->post(
    '/groupProviderMedia',
    [
        'uses' => 'GroupProviderMedia\\GroupProviderMediaInsertController@__invoke'
    ]
);

$router->get(
    '/groupProviderMedia/{Id}',
    [
        'uses' => 'GroupProviderMedia\\GroupProviderMediaIndexController@__invoke'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/groupProviderMedia/{Id}/download',
    [
        'uses' => 'GroupProviderMedia\\GroupProviderMediaDownloadIndexController@__invoke'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/groupProvider/{Id_GroupProvider}/groupProviderMedia/{Action}',
    [
        'uses' => 'GroupProviderMedia\\GroupProviderMediaListController@__invoke'
    ]
)->where('Id_GroupProvider', '[0-9]*');
