<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactUnit\Domain\FactUnitRepository;
use App\Modules\FactUnit\Infraestructure\MysqlFactUnitRepository;

$app->bind(FactUnitRepository::class, fn($app) => $app->make(MysqlFactUnitRepository::class));

$router->put(
    '/factUnit',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactUnit\\FactUnitUpdateController@__invoke'
    ]
);

$router->get(
    '/factUnit/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactUnit\\FactUnitIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factUnit/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactUnit\\FactUnitListController@__invoke'
    ]
);
