<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactProduct\Domain\FactProductRepository;
use App\Modules\FactProduct\Infraestructure\MysqlFactProductRepository;

$app->bind(FactProductRepository::class, fn($app) => $app->make(MysqlFactProductRepository::class));

$router->put(
    '/factProduct',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactProduct\\FactProductUpdateController@__invoke'
    ]
);

$router->get(
    '/factProduct/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactProduct\\FactProductIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factProduct/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactProduct\\FactProductListController@__invoke'
    ]
);
