<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactPaymentMethod\Domain\FactPaymentMethodRepository;
use App\Modules\FactPaymentMethod\Infrastructure\MysqlFactPaymentMethodRepository;

$app->bind(FactPaymentMethodRepository::class, fn ($app) => $app->make(MysqlFactPaymentMethodRepository::class));

$router->post(
    '/factPaymentMethod',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactPaymentMethod\\FactPaymentMethodInsertController@__invoke'
    ]
);

$router->put(
    '/factPaymentMethod',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactPaymentMethod\\FactPaymentMethodUpdateController@__invoke'
    ]
);

$router->get(
    '/factPaymentMethod/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactPaymentMethod\\FactPaymentMethodIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factPaymentMethod/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactPaymentMethod\\FactPaymentMethodListController@__invoke'
    ]
);

$router->delete(
    '/factPaymentMethod/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactPaymentMethod\\FactPaymentMethodDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
