<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->post(
    '/externalReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewInsertController@__invoke'
    ]
);

$router->put(
    '/externalReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewUpdateController@__invoke'
    ]
);

$router->delete(
    '/externalReview/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/externalReview/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/externalReview/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\ExternalReviewListController@__invoke'
    ]
);

$router->get(
    'groupPassenger/{IdGroupPassenger}/externalReview/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'ExternalReview\\GroupExternalReviewListController@__invoke'
    ]
)->where('IdGroupPassenger', '[0-9]*');
