<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingUpgradePassenger\Domain\BookingUpgradePassengerRepository;
use App\Modules\BookingUpgradePassenger\Infrastructure\MysqlBookingUpgradePassengerRepository;

$app->bind(BookingUpgradePassengerRepository::class, fn ($app) => $app->make(MysqlBookingUpgradePassengerRepository::class));

$router->put(
    '/bookingUpgradePassenger/{Id}/reset',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger\\BookingUpgradePassengerResetController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->put(
    '/bookingUpgradePassenger/mask',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger\\BookingUpgradePassengerMaskController@__invoke'
    ]
);

$router->post(
    '/bookingUpgradePassenger/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@Insert_All'
    ]
);
$router->post(
    '/bookingUpgradePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@Insert'
    ]
);
$router->put(
    '/bookingUpgradePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@Update'
    ]
);
$router->put(
    '/bookingUpgradePassenger/entry',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@UpdateDateEntry'
    ]
);
$router->put(
    '/bookingUpgradePassenger/simple',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@simpleUpdate'
    ]
);
$router->delete(
    '/bookingUpgradePassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@Delete'
    ]
)->where('Id', '[0-9]*');

$router->get(
    '/bookingUpgradePassenger/listByIds',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingUpgradePassenger\\BookingUpgradePassengerByIdsController@__invoke'
    ]
);

$router->put(
    '/bookingUpgradePassenger/massive',
    [
        'middleware' => 'Auth_Owner', 'uses' => 'BookingUpgradePassenger\\BookingUpgradePassengerMassiveUpdateController@__invoke'
    ]
);

$router->get(
    '/bookingUpgradePassenger/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@Index'
    ]
)->where('Id', '[0-9]*');
$router->get(
    '/bookingUpgrade/{Id_BookingUpgrade}/bookingUpgradePassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@List'
    ]
);
$router->get(
    '/bookingUpgrade/bookingUpgradePassenger/search',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingUpgradePassenger@Search'
    ]
);
$router->get(
    '/bookingUpgrade/bookingUpgradePassenger/exportExcel',
    [
        'uses' => 'BookingUpgradePassenger@ExportExcel'
    ]
);
