<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingTourItem\Domain\EquipmentRepository;
use App\Modules\BookingTourItem\Domain\ExtraRepository;
use App\Modules\BookingTourItem\Domain\UpgradeRepository;
use App\Modules\BookingTourItem\Infraestructure\MysqlEquipmentRepository;
use App\Modules\BookingTourItem\Infraestructure\MysqlExtraRepository;
use App\Modules\BookingTourItem\Infraestructure\MysqlUpgradeRepository;
use Illuminate\Support\Facades\Route;

$app->bind(UpgradeRepository::class, fn($app) => $app->make(MysqlUpgradeRepository::class));
$app->bind(ExtraRepository::class, fn($app) => $app->make(MysqlExtraRepository::class));
$app->bind(EquipmentRepository::class, fn($app) => $app->make(MysqlEquipmentRepository::class));

Route::get(
    '/bookingTour/{idBookingTour}/upgrade/{action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingTour\\UpgradeListController@__invoke'
    ]
)->where('idBookingTour', '[0-9]*');

// Route::get(
//     '/bookingTour/{idBookingTour}/extra/{action}',
//     [
//         'middleware' => 'Auth_Owner',
//         'uses' => 'BookingTour\\ExtraListController@__invoke'
//     ]
// )->where('idBookingTour', '[0-9]*');

// Route::get(
//     '/bookingTour/{idBookingTour}/equipment/{action}',
//     [
//         'middleware' => 'Auth_Owner',
//         'uses' => 'BookingTour\\EquipmentListController@__invoke'
//     ]
// )->where('idBookingTour', '[0-9]*');
