<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\Admin\Domain\AdminRepository;
use App\Modules\Admin\Infrastructure\MysqlAdminRepository;

$app->bind(AdminRepository::class, fn ($app) => $app->make(MysqlAdminRepository::class));

$router->get(
    "/rolePermission/list",
    [
        "uses" => "Admin@Permiso"
    ]
);

$router->post(
    '/admin',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@Insert'
    ]
);

$router->post(
    '/admin/update',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@Update'
    ]
);

$router->delete(
    '/admin/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@Delete'
    ]
);

$router->get(
    '/admin/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@Selector'
    ]
);

$router->get(
    '/adminToken',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@IndexToken'
    ]
);

$router->put(
    '/change-password',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@Password'
    ]
);

$router->put(
    '/change-admin-password',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Admin@ChangePassword'
    ]
);
