<?php

namespace App\Providers;

class StorageProvider
{
    public function publicPath($route)
    {
        return config('var.PATH_PUBLIC') . $route;
    }

    public function privatePath($file)
    {
        return config('var.PATH_PRIVATE') . $file;
    }

    public function appendPublicToObject(object &$object, string $key)
    {
        if ($object->$key) {
            $object->$key = $this->publicPath($object->$key);
        }
        return $object;
    }

    public function appendPrivateToObject(object &$object, string $key)
    {
        if ($object->$key) {
            $object->$key = $this->privatePath($object->$key);
        }
        return $object;
    }
}
