<?php

namespace App\Providers;

use App\Http\Controllers\Owner\Booking;
use App\Http\Helpers\ParamsValidator;
use App\Mail\MailBooking;
use App\Modules\EmailShip\Application\EmailShipShipper;
use App\Modules\EmailShip\Infraestructure\MysqlEmailShipRepository;
use App\Modules\EmailShip\Infraestructure\MysqlEmailShipShippedRepository;
use App\Providers\UserBooking\UserBookingPdf;
use Illuminate\Support\Facades\DB;
use Throwable;
use Dompdf\Dompdf;

class BookingMailSender
{

    public const ONLY_REGULAR = 1;
    public const ONLY_PAYMENT = 2;
    public const REGULAR_AND_PAYMENT = 3;

    public static $amount = 0;

    public static function addPassengers($booking)
    {
        $Path_ImgDocument1_Thumb = config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_THUMB");
        $Path_ImgDocument1_Large = config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_LARGE");
        $Path_ImgDocument2_Thumb = config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_THUMB");
        $Path_ImgDocument2_Large = config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_LARGE");

        $oParam = [
            'all',
            $booking->Id_Booking,
            $Path_ImgDocument1_Thumb,
            $Path_ImgDocument1_Large,
            $Path_ImgDocument2_Thumb,
            $Path_ImgDocument2_Large
        ];

        $booking->Booking_Passenger     = DB::select('call sp_client_passenger_list(?,?,?,?,?,?)', $oParam);
        return $booking;
    }

    public static function addInvoices($booking)
    {
        $booking->Booking_Invoice = array_map(
            function ($invoice) {
                return self::addInvoiceFee($invoice);
            },
            DB::select('call sp_client_invoice_list(?)', [$booking->Id_Booking])
        );
        return $booking;
    }

    public static function addInvoiceFee($invoice)
    {
        $invoice->BookingInvoice_Fee = DB::select('call sp_invoice_fee_list(?)', [$invoice->Id_Invoice]);
        return $invoice;
    }

    public static function addBookingTour($booking)
    {
        $booking->Booking_Tour = array_map(
            function ($bookingTour) {

                $bookingTour->Passengers            = DB::select('call sp_booking_tour_passenger_list(?,?,?,?)', ['all', $bookingTour->Id_BookingTour, 0, '']);
                $bookingTour->BookingTour_Upgrade   = DB::select('call sp_booking_upgrade_list(?)', [$bookingTour->Id_BookingTour]);
                $bookingTour->BookingTour_Extra     = DB::select('call sp_booking_extra_list(?)', [$bookingTour->Id_BookingTour]);
                $bookingTour->BookingTour_Equipment = DB::select('call sp_booking_equipment_list(?)', [$bookingTour->Id_BookingTour]);
                return $bookingTour;
            },
            DB::select('call sp_booking_tour_list(?)', [$booking->Id_Booking])
        );
        return $booking;
    }

    public static function getUser($Id_User)
    {
        return DB::select('call sp_client_user_index(?)', [$Id_User]);
    }

    public static function getAdmin($Id_Admin)
    {
        return DB::select('call sp_admin_index(?)', [$Id_Admin]);
    }

    public static function getWebUrl()
    {
        $oCredentials   = DB::select('call sp_credential_list()', []);
        return self::filterCredential($oCredentials, 'Web_URL');
    }

    public static function getClientWebUrl()
    {
        $oCredentials   = DB::select('call sp_credential_list()', []);
        return self::filterCredential($oCredentials, 'Client_Web_URL');
    }

    public static function getOwner()
    {
        $filter         = array_reduce(self::getCredentialList(), function ($carry, $credential) {
            return $credential->Credential_key == 'Mail' ? [$credential] : $carry;
        }, []);
        return $filter;
    }

    public static function getResourcesUrl()
    {
        $filter         = array_reduce(self::getCredentialList(), function ($carry, $credential) {
            return $credential->Credential_key == 'Resources_URL' ? [$credential] : $carry;
        }, []);
        return $filter;
    }

    public static function getCredentialList()
    {
        return DB::select('call sp_credential_list()', []);
    }

    public static function filterCredential($oCredentials, $Credential_Key)
    {
        return array_values(array_filter($oCredentials, function ($credential) use ($Credential_Key) {
            return $credential->Credential_key == $Credential_Key;
        }));
    }

    public static function sendBookingByMailInvoice($Id_Invoice, $oDomain)
    {
        $oData_Invoice  = DB::select('call sp_invoice_get(?)', [$Id_Invoice]);
        return self::sendBookingByMail($oData_Invoice[0]->Id_Booking, $oDomain);
    }

    public static function sendMailTo($Email, $bcc, $replyTo, $Subject, $Booking, $ResourcesUrl, $test = false)
    {
        try {
            $pdf = new UserBookingPdf();

            $dompdf = new Dompdf();
            $options = $dompdf->getOptions();
            $options->setIsRemoteEnabled(true);
            $dompdf->setOptions($options);
            $dompdf->loadHtml($pdf->build([
                'Booking'       => $Booking,
                'Lang'          => 1,
                'ResourcesUrl'  => $ResourcesUrl //__DIR__ . '/../../resources/'
            ]));

            $dompdf->setPaper('A4', 'portrait');
            $dompdf->render();

            $mailBooking = new MailBooking(
                $Subject,
                [
                    'Booking'       => $Booking,
                    'Lang'          => 1,
                    'ResourcesUrl'  => $ResourcesUrl
                ],
                $dompdf->output(),
                'Booking Confirmation ' . $Booking->Booking_Code,
                $replyTo
            );

            if ($test) {
                return $mailBooking->build();
            } else {
                $shipper = new EmailShipShipper(
                    new MysqlEmailShipShippedRepository,
                    new MysqlEmailShipRepository
                );
                $shipper->__invoke($Email, $bcc, [], $mailBooking);
            }
        } catch (Throwable $t) {
            throw $t;
        }
    }

    public static function GetInvoiceList($Id_Booking)
    {
        return array_map(function ($invoice) {
            return ['Id' => $invoice->Id_Invoice];
        }, DB::select('CALL sp_invoice_list(?,?)', [$Id_Booking, '']));
    }

    public static function sendBookingByMail($Id_Booking, $oDomain, $type = self::ONLY_REGULAR, $test = false)
    {
        $oBooking = null;
        try {
            $oResponse = ParamsValidator::Validate_Id($Id_Booking, $oDomain);

            if ($oResponse['Response_Code'] != 200) {
                return $oResponse;
            }

            $invoiceListJSON = json_encode(self::GetInvoiceList($Id_Booking));
            $oBooking = Booking::getReportData($Id_Booking, $invoiceListJSON);

            foreach ($oBooking as $booking) {
                $user = self::getUser($booking->Id_User)[0];
                if ($booking->Id_Admin > 0) {
                    $admin = $booking->Admin_EmailAddress;
                } else {
                    $admin = null;
                }
                $credentials = self::getCredentialList();
                $mails = [];

                switch ($type) {
                    case self::ONLY_REGULAR:
                        $mails = self::mergeCredentials($mails, 'Mail', $credentials);
                        break;
                    case self::ONLY_PAYMENT:
                        $mails = self::mergeCredentials($mails, 'Mail_Payments', $credentials);
                        if (!$admin) {
                            $mails = self::mergeCredentials($mails, 'Mail_Payments_Default', $credentials);
                        }
                        break;
                    case self::REGULAR_AND_PAYMENT:
                        $mails = self::mergeCredentials($mails, 'Mail', $credentials);
                        $mails = self::mergeCredentials($mails, 'Mail_Payments', $credentials);
                        if (!$admin) {
                            $mails = self::mergeCredentials($mails, 'Mail_Payments_Default', $credentials);
                        }
                        break;
                }

                $replyTo = self::mergeCredentials([], 'Mail_ReplyTo', $credentials);

                $ResourcesUrl = BookingMailSender::getResourcesUrl()[0]->Credential_Value;

                try {
                    self::$amount++;
                    if (self::$amount <= 1) {
                        $bcc = [];
                        if ($admin) {
                            $bcc[] = ['email' => $admin];
                        }
                        foreach ($mails as $mail) {
                            if (filter_var($mail['email'], FILTER_VALIDATE_EMAIL)) {
                                $bcc[] = $mail;
                            }
                        }

                        $credentialMails = [['email' => trim($user->User_Email)]];
                        if ($test) {
                            return self::sendMailTo($credentialMails, $bcc, $replyTo, 'Your Booking ' . $booking->Booking_Code, $booking, $ResourcesUrl);
                        } else {
                            self::sendMailTo($credentialMails, $bcc, $replyTo, 'Your Booking ' . $booking->Booking_Code, $booking, $ResourcesUrl);
                        }
                    }
                } catch (\Throwable $t) {
                    // dd($t->getMessage());
                }
            }
        } catch (\Throwable $t) {
        }

        $oResponse = [
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Domain"           => $oDomain,
            "Response_Message"          => 'Email enviado',
            "Response_Data"             => $oBooking,
            "Response_Error_Message"    => "",
            "Response_Error_Reason"     => ""
        ];

        return $oResponse;
    }

    public static function mergeCredentials($data, $credentialKey, $credentialList)
    {
        return array_merge($data, self::cutCredentials(self::filterCredential($credentialList, $credentialKey)[0]->Credential_Value));
    }

    public static function cutCredentials($credentials)
    {
        $credentialMails = explode(',', $credentials);
        $credentialMails = array_map(function ($mail) {
            return ['email' => trim($mail)];
        }, $credentialMails);
        return $credentialMails;
    }
}
