<?php

namespace App\Providers;

use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Infraestructure\Command\IlluminateCommandBus;
use App\Modules\Shared\Infraestructure\Command\InMemoryCommandBus;
use App\Modules\Shared\Infraestructure\Query\IlluminateQueryBus;
use App\Modules\Shared\Infraestructure\Query\InMemoryQueryBus;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(
            QueryBus::class,
            InMemoryQueryBus::class
            // IlluminateQueryBus::class
        );
        $this->app->singleton(
            CommandBus::class,
            InMemoryCommandBus::class
            // IlluminateCommandBus::class
        );
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
