<?php

namespace App\Modules\WebContactMessageDetail\Domain;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;

/**
 * Status in the group for filtering and display
 */
class WebContactMessageDetail
{

    public function __construct(
        private WebContactMessageDetailDateStart $dateStart,
        private WebContactMessageDetailPackage $package,
        private WebContactMessageDetailStatus $status,
        private IdWebContactMessage $idWebContactMessage,
        private IdPackage $idPackage,
        private ?IdWebContactMessageDetail $id = null,
    ) {
    }

    public function id(): IdWebContactMessageDetail
    {
        return $this->id;
    }

    public function dateStart(): WebContactMessageDetailDateStart
    {
        return $this->dateStart;
    }

    public function package(): WebContactMessageDetailPackage
    {
        return $this->package;
    }

    public function status(): WebContactMessageDetailStatus
    {
        return $this->status;
    }

    public function idWebContactMessage(): IdWebContactMessage
    {
        return $this->idWebContactMessage;
    }

    public function idPackage(): IdPackage
    {
        return $this->idPackage;
    }
}
