<?php

namespace App\Modules\WebContactMessageDetail\Application\Update;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\WebContactMessageDetail\Domain\IdWebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailDateStart;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailMessage;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailPackage;

final class UpdateWebContactMessageDetailQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageDetailUpdater $updater)
    {
    }

    public function __invoke(UpdateWebContactMessageDetailQuery $query): UpdateWebContactMessageDetailQueryResponse
    {
        $model = new WebContactMessageDetail(
            new WebContactMessageDetailDateStart($query->dateStart()),
            new WebContactMessageDetailPackage($query->package()),
            new WebContactMessageDetailStatus($query->status()),
            new IdWebContactMessage($query->idWebContactMessage()),
            new IdPackage(0),
            new IdWebContactMessageDetail($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
