<?php

namespace App\Modules\WebContactMessageDetail\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;

final class ListWebContactMessageDetailQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageDetailLister $inserter)
    {
    }

    public function __invoke(ListWebContactMessageDetailQuery $query): ListWebContactMessageDetailQueryResponse
    {
        return $this->inserter->__invoke(
            new IdWebContactMessage($query->idWebContactMessage()),
            $query->action()
        );
    }
}
