<?php

namespace App\Modules\WebContactMessageDetail\Application\Delete;

use App\Modules\WebContactMessageDetail\Domain\IdWebContactMessageDetail;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteWebContactMessageDetailQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageDetailDeleter $inserter)
    {
    }

    public function __invoke(DeleteWebContactMessageDetailQuery $query): DeleteWebContactMessageDetailQueryResponse
    {
        return $this->inserter->__invoke(new IdWebContactMessageDetail($query->getId()));
    }
}
