<?php

namespace App\Modules\WebContactMessage\Application\Update;

use App\Modules\WebContactMessage\Application\Update\UpdateWebContactMessageQueryResponse;
use App\Modules\WebContactMessage\Domain\UpdateWebContactMessage;
use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;

final class WebContactMessageUpdater
{
    public function __construct(private WebContactMessageRepository $repository)
    {
    }

    public function __invoke(UpdateWebContactMessage $webContactMessage): UpdateWebContactMessageQueryResponse
    {
        return new UpdateWebContactMessageQueryResponse($this->repository->update($webContactMessage));
    }
}
