<?php

namespace App\Modules\WebContactMessage\Application\ListAll;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class ListAllWebContactMessageQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageAllLister $allLister)
    {
    }

    public function __invoke(ListAllWebContactMessageQuery $query): ListAllWebContactMessageQueryResponse
    {
        return $this->allLister->__invoke(
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->action()
        );
    }
}
