<?php

namespace App\Modules\WebContactMessage\Application\Delete;

use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteWebContactMessageQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageDeleter $inserter)
    {
    }

    public function __invoke(DeleteWebContactMessageQuery $query): DeleteWebContactMessageQueryResponse
    {
        return $this->inserter->__invoke(new IdWebContactMessage($query->getId()));
    }
}
