<?php

namespace App\Modules\WebContact\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactRepository;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContact\Domain\UpdateWebContact;
use App\Modules\WebContact\Domain\WebContactEmail;

class MysqlWebContactRepository implements WebContactRepository
{

    public function find(string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function search(WebContactEmail $email)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_search(?,@sts,@cod,@msg)',
            [
                $email->value()
            ]
        );
    }

    public function index(IdWebContact $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_web_contact_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(WebContact $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_web_contact_insert(?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->lastName()->value(),
                $value->email()->value(),
                $value->country()->value(),
                $value->countryCurrent()->value(),
                $value->phoneCode()->value(),
                $value->phone()->value(),
                $value->status()->value(),
                $value->idCountry()->value(),
                $value->idCountryCurrent()->value(),
            ]
        );
    }

    public function update(UpdateWebContact $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_web_contact_update(?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->lastName()->value(),
                $value->email()->value(),
                $value->phoneCode()->value(),
                $value->phone()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function delete(IdWebContact $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_web_contact_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
