<?php

namespace App\Modules\WebContact\Application\Index;

use App\Modules\WebContact\Application\Index\IndexWebContactQueryResponse;
use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactRepository;

final class WebContactIndexer
{
    public function __construct(private WebContactRepository $repository)
    {
    }

    public function __invoke(IdWebContact $idWebContact): IndexWebContactQueryResponse
    {
        return new IndexWebContactQueryResponse($this->repository->index($idWebContact));
    }
}
