<?php

namespace App\Modules\WebContact\Application\Find;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\WebContactEmail;

final class FindWebContactQueryHandler implements QueryHandler
{
    public function __construct(private WebContactFinder $finder)
    {
    }

    public function __invoke(FindWebContactQuery $query): FindWebContactQueryResponse
    {
        return $this->finder->__invoke(
            new WebContactEmail($query->email())
        );
    }
}
