<?php

namespace App\Modules\User\Application\SearchBookingReport;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\User\Domain\IdUser;
use App\Modules\User\Domain\UserRepository;

final class UserBookingByTourSearcher
{
    public function __construct(private UserRepository $repository)
    {
    }

    public function __invoke(IdUser $idUser, DateStart $dateStart, DateEnd $dateEnd)
    {
        return $this->repository->bookingListByTour($idUser, $dateStart, $dateEnd);
    }
}
