<?php

namespace App\Modules\TourQuestion\Domain;

use App\Modules\Question\Domain\IdQuestion;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\Tour\Domain\IdTour;

class TourQuestion extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdTourQuestion::class, 'Id_TourQuestion', 'primary'),
            new AggregateAttribute('order', TourQuestionOrder::class, 'TourQuestion_Order'),
            new AggregateAttribute('idTour', IdTour::class, 'Id_Tour'),
            new AggregateAttribute('idQuestion', IdQuestion::class, 'Id_Question'),
        ];
    }

    public static function table(): string
    {
        return 't_tour_question';
    }

    public function __construct(
        protected IdTourQuestion $id,
        protected TourQuestionOrder $order,
        protected IdTour $abrv,
        protected IdQuestion $status,
    ) {
    }

    public function id(): IdTourQuestion
    {
        return $this->id;
    }

    public function order(): TourQuestionOrder
    {
        return $this->order;
    }

    public function abrv(): IdTour
    {
        return $this->abrv;
    }

    public function status(): IdQuestion
    {
        return $this->status;
    }
}
