<?php

namespace App\Modules\Tour\Domain;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\City\Domain\IdCity;
use App\Modules\Country\Domain\IdCountry;
use App\Modules\State\Domain\IdState;
use App\Modules\TypeTour\Domain\IdTypeTour;

class TourModel
{

    /** constructor */
    public function __construct(
        private TourCode $code,
        private TourName $name,
        private TourUrlThumbnail $urlThumbnail,
        private TourDuration $duration,
        private TourMinPax $minPax,
        private TourAvailability $availability,
        private TourAvailabilityStatus $availabilityStatus,
        private TourAnticipation $anticipation,
        private TourAnticipationType $anticipationType,
        private TourColor $color,
        private TourScore $score,
        private TourStatus $status,
        private IdCategoryTour $idCategoryTour,
        private IdTypeTour $idTypeTour,
        private IdCountry $idCountry,
        private IdState $idState,
        private IdCity $idCity,
        private ?IdTour $id = null
    ) {}

    public function code(): TourCode
    {
        return $this->code;
    }
    public function name(): TourName
    {
        return $this->name;
    }
    public function urlThumbnail(): TourUrlThumbnail
    {
        return $this->urlThumbnail;
    }
    public function duration(): TourDuration
    {
        return $this->duration;
    }
    public function minPax(): TourMinPax
    {
        return $this->minPax;
    }
    public function availability(): TourAvailability
    {
        return $this->availability;
    }
    public function availabilityStatus(): TourAvailabilityStatus
    {
        return $this->availabilityStatus;
    }
    public function anticipation(): TourAnticipation
    {
        return $this->anticipation;
    }
    public function anticipationType(): TourAnticipationType
    {
        return $this->anticipationType;
    }
    public function color(): TourColor
    {
        return $this->color;
    }
    public function score(): TourScore
    {
        return $this->score;
    }
    public function status(): TourStatus
    {
        return $this->status;
    }
    public function idCategoryTour(): IdCategoryTour
    {
        return $this->idCategoryTour;
    }
    public function idTypeTour(): IdTypeTour
    {
        return $this->idTypeTour;
    }
    public function idCountry(): IdCountry
    {
        return $this->idCountry;
    }
    public function idState(): IdState
    {
        return $this->idState;
    }
    public function idCity(): IdCity
    {
        return $this->idCity;
    }
    public function id(): IdTour
    {
        return $this->id;
    }
}
