<?php

namespace App\Modules\Tour\Domain;

use App\Modules\CategoryTour\Domain\CategoryTour;
use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\City\Domain\IdCity;
use App\Modules\Country\Domain\IdCountry;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\State\Domain\IdState;
use App\Modules\TypeTour\Domain\IdTypeTour;
use App\Modules\TypeTour\Domain\TypeTour;

class Tour extends AggregateRoot
{
    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdTour::class, 'Id_Tour'),
            new AggregateAttribute('code', TourCode::class, 'Tour_Code'),
            new AggregateAttribute('name', TourName::class, 'Tour_Name'),
            new AggregateAttribute('urlThumbnail', TourUrlThumbnail::class, 'Tour_UrlThumbnail'),
            new AggregateAttribute('duration', TourDuration::class, 'Tour_Duration'),
            new AggregateAttribute('minPax', TourMinPax::class, 'Tour_MinPax'),
            new AggregateAttribute('availability', TourAvailability::class, 'Tour_Availability'),
            new AggregateAttribute('availabilityStatus', TourAvailabilityStatus::class, 'Tour_AvailabilityStatus'),
            new AggregateAttribute('anticipation', TourAnticipation::class, 'Tour_Anticipation'),
            new AggregateAttribute('anticipationType', TourAnticipationType::class, 'Tour_AnticipationType'),
            new AggregateAttribute('color', TourColor::class, 'Tour_Color'),
            new AggregateAttribute('score', TourScore::class, 'Tour_Score'),
            new AggregateAttribute('scoreCant', TourScoreCant::class, 'Tour_ScoreCant'),
            new AggregateAttribute('scoreTotal', TourScoreTotal::class, 'Tour_ScoreTotal'),
            new AggregateAttribute('status', TourStatus::class, 'Tour_Status'),
            new AggregateAttribute('idCategoryTour', IdCategoryTour::class, 'Id_CategoryTour'),
            new AggregateAttribute('idTypeTour', IdTypeTour::class, 'Id_TypeTour'),
            new AggregateAttribute('idCountry', IdCountry::class, 'Id_Country'),
            new AggregateAttribute('idState', IdState::class, 'Id_State'),
            new AggregateAttribute('idCity', IdCity::class, 'Id_City'),
        ];
    }

    private ?CategoryTour $categoryTour;
    private ?TypeTour $typeTour;

    /** constructor */
    public function __construct(
        private IdTour $id,
        private TourCode $code,
        private TourName $name,
        private TourUrlThumbnail $urlThumbnail,
        private TourDuration $duration,
        private TourMinPax $minPax,
        private TourAvailability $availability,
        private TourAvailabilityStatus $availabilityStatus,
        private TourAnticipation $anticipation,
        private TourAnticipationType $anticipationType,
        private TourColor $color,
        private TourScore $score,
        private TourScoreCant $scoreCant,
        private TourScoreTotal $scoreTotal,
        private TourStatus $status,
        private IdCategoryTour $idCategoryTour,
        private IdTypeTour $idTypeTour,
        private IdCountry $idCountry,
        private IdState $idState,
        private IdCity $idCity
    ) {}

    public function id(): IdTour
    {
        return $this->id;
    }

    public function code(): TourCode
    {
        return $this->code;
    }

    public function name(): TourName
    {
        return $this->name;
    }

    public function urlThumbnail(): TourUrlThumbnail
    {
        return $this->urlThumbnail;
    }

    public function duration(): TourDuration
    {
        return $this->duration;
    }

    public function minPax(): TourMinPax
    {
        return $this->minPax;
    }

    public function availability(): TourAvailability
    {
        return $this->availability;
    }

    public function availabilityStatus(): TourAvailabilityStatus
    {
        return $this->availabilityStatus;
    }

    public function anticipation(): TourAnticipation
    {
        return $this->anticipation;
    }

    public function anticipationType(): TourAnticipationType
    {
        return $this->anticipationType;
    }

    public function color(): TourColor
    {
        return $this->color;
    }

    public function score(): TourScore
    {
        return $this->score;
    }

    public function scoreCant(): TourScoreCant
    {
        return $this->scoreCant;
    }

    public function scoreTotal(): TourScoreTotal
    {
        return $this->scoreTotal;
    }

    public function status(): TourStatus
    {
        return $this->status;
    }

    public function idCategoryTour(): IdCategoryTour
    {
        return $this->idCategoryTour;
    }

    public function idTypeTour(): IdTypeTour
    {
        return $this->idTypeTour;
    }

    public function idCountry(): IdCountry
    {
        return $this->idCountry;
    }

    public function idState(): IdState
    {
        return $this->idState;
    }

    public function idCity(): IdCity
    {
        return $this->idCity;
    }

    public function setTypeTour(TypeTour $typeTour)
    {
        $this->typeTour = $typeTour;
    }

    public function setCategoryTour(CategoryTour $categoryTour)
    {
        $this->categoryTour = $categoryTour;
    }

    public function typeTour(): ?TypeTour
    {
        return $this->typeTour ?? null;
    }

    public function categoryTour()
    {
        return $this->categoryTour ?? null;
    }
}
