<?php

namespace App\Modules\Tour\Domain;

use App\Modules\CategoryTour\Domain\CategoryTour;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\TypeTour\Domain\TypeTour;
use Illuminate\Support\Facades\DB;

/**
 * @extends StorageCriteria<Tour>
 */
class ListTour implements StorageCriteria
{

    private $allowedAggregations = [
        'TypeTour',
        'CategoryTour'
    ];

    private Aggregations $aggregationList;

    public function __construct(
        private TourAction $list,
        private TypeTours $typeTours,
        private CategoryTours $categoryTours,
        private Aggregations $aggregations,
        private QueryPaginate $queryPaginate,
    ) {}

    public function run()
    {
        return $this->analize($this->query());
    }

    private function initialiceAggregations(Aggregations $aggregations)
    {
        $this->aggregationList = new Aggregations();
        foreach ($aggregations->data() as $aggregation) {
            if ($this->isAggregationAllowed($aggregation)) {
                $this->aggregationList->addAggregation($aggregation);
            }
        }
    }

    private function aggregateToSelect()
    {
        $select = Tour::selectUnique('`t`');
        foreach ($this->aggregationList->data() as $aggregation) {
            if ($aggregation->value() == 'CategoryTour') {
                $select .= ',' . CategoryTour::selectUnique('`ct`');
            }
            if ($aggregation->value() == 'TypeTour') {
                $select .= ',' . TypeTour::selectUnique('`tt`');
            }
        }
        return $select;
    }

    private function aggregateToFrom()
    {
        $select = '`t_tour` `t`';
        foreach ($this->aggregationList->data() as $aggregation) {
            if ($aggregation->value() == 'CategoryTour') {
                $select .= ' INNER JOIN `t_category_tour` `ct` ON `ct`.`Id_CategoryTour` = `t`.`Id_CategoryTour`';
            }
            if ($aggregation->value() == 'TypeTour') {
                $select .= ' INNER JOIN `t_type_tour` `tt` ON `tt`.`Id_TypeTour` = `t`.`Id_TypeTour`';
            }
        }
        return $select;
    }

    private function isAggregationAllowed(Aggregation $aggregation)
    {
        return in_array($aggregation->value(), $this->allowedAggregations);
    }

    protected function query()
    {
        $this->initialiceAggregations($this->aggregations);
        $select = $this->aggregateToSelect();
        $from = $this->aggregateToFrom();
        return DB::select(
            "SELECT $select
            FROM $from
            ORDER BY `t`.`Id_Tour` ASC",
            []
        );
    }

    protected function analize($data)
    {
        $v = $this;
        return array_map(function ($data) use (&$v) {
            $tour = Tour::fromDTOUnique($data);
            foreach ($v->aggregationList->data() as $aggregation) {
                if ($aggregation->value() == 'CategoryTour') {
                    $tour->setCategoryTour(CategoryTour::fromDTOUnique($data));
                }
                if ($aggregation->value() == 'TypeTour') {
                    $tour->setTypeTour(TypeTour::fromDTOUnique($data));
                }
            }
            return $tour;
        }, $data);
    }
}
