<?php

namespace App\Modules\StatusGroupProvider\Application\Update;

use App\Modules\StatusGroupProvider\Application\Update\UpdateStatusGroupProviderQueryResponse;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;

final class StatusGroupProviderUpdater
{
    public function __construct(private StatusGroupProviderRepository $repository)
    {
    }

    public function __invoke(StatusGroupProvider $model): UpdateStatusGroupProviderQueryResponse
    {
        return new UpdateStatusGroupProviderQueryResponse($this->repository->update($model));
    }
}
