<?php

namespace App\Modules\StatusGroupProvider\Application\Index;

use App\Modules\StatusGroupProvider\Application\Index\IndexStatusGroupProviderQueryResponse;
use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;

final class StatusGroupProviderIndexer
{
    public function __construct(private StatusGroupProviderRepository $repository)
    {
    }

    public function __invoke(IdStatusGroupProvider $idStatusGroupProvider): IndexStatusGroupProviderQueryResponse
    {
        return new IndexStatusGroupProviderQueryResponse($this->repository->index($idStatusGroupProvider));
    }
}
