<?php

namespace App\Modules\StatusGroup\Domain;


/**
 * Status in the group for filtering and display
 */
class StatusGroup
{

    public function __construct(
        private StatusGroupName $name,
        private StatusGroupAbrv $abrev,
        private StatusGroupColor $color,
        private StatusGroupStatus $status,
        private ?IdStatusGroup $id = null,
    ) {
    }

    public function id(): IdStatusGroup
    {
        return $this->id;
    }

    public function name(): StatusGroupName
    {
        return $this->name;
    }

    public function abrev(): StatusGroupAbrv
    {
        return $this->abrev;
    }

    public function color(): StatusGroupColor
    {
        return $this->color;
    }

    public function status(): StatusGroupStatus
    {
        return $this->status;
    }

}
