<?php

namespace App\Modules\ReviewSession\Application\Create;

use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\Shared\Domain\Bus\Command\CommandHandler;

final class CreateReviewSessionHandler implements CommandHandler
{
    public function __construct(
        private ReviewSessionCreator $creator
    ) {
    }

    public function __invoke(CreateReviewSessionCommand $command)
    {
        return $this->creator->create(new PassengerNoDocument($command->noDocument()));
    }
}
