<?php

namespace App\Modules\ReviewNotification\Application\Update;

use App\Modules\ReviewNotification\Domain\IdReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationDescription;
use App\Modules\ReviewNotification\Domain\ReviewNotificationStatus;
use App\Modules\ReviewNotification\Domain\UpdateReviewNotification;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReviewNotificationUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private ReviewNotificationUpdater $updater)
    {
    }

    public function __invoke(ReviewNotificationUpdaterQuery $query): ReviewNotificationUpdaterResponse
    {
        $model = new UpdateReviewNotification(
            new ReviewNotificationDescription($query->getDescription()),
            new ReviewNotificationStatus($query->getStatus()),
            new IdReviewNotification($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
