<?php

namespace App\Modules\ReviewNotification\Application\Reply;

use App\Modules\ReviewNotification\Application\Reply\ReplyReviewNotificationResponse;
use App\Modules\ReviewNotification\Domain\InsertReviewNotification;
use App\Modules\ReviewNotification\Domain\ReviewNotificationRepository;

final class ReviewNotificationReplier
{
    public function __construct(private ReviewNotificationRepository $repository)
    {
    }

    public function __invoke(InsertReviewNotification $reviewNotification): ReplyReviewNotificationResponse
    {
        return new ReplyReviewNotificationResponse($this->repository->insert($reviewNotification));
    }
}
