<?php

namespace App\Modules\ProviderTypeProvider\Domain;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

class ProviderTypeProvider
{

    public function __construct(
        private ProviderTypeProviderStatus $status,
        private IdProvider $idProvider,
        private IdTypeProvider $idTypeProvider,
        private ?IdProviderTypeProvider $id = null
    ) {
    }

    public function getId(): IdProviderTypeProvider
    {
        return $this->id;
    }
    public function getStatus(): ProviderTypeProviderStatus
    {
        return $this->status;
    }
    public function getIdProvider(): IdProvider
    {
        return $this->idProvider;
    }
    public function getIdTypeProvider(): IdTypeProvider
    {
        return $this->idTypeProvider;
    }
}
