<?php

namespace App\Modules\ProviderTypeProvider\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ProviderTypeProviderUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private int $status,
        private int $idProvider,
        private int $idTypeProvider
    ) {
    }

    public function id(): string
    {
        return $this->id;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function idProvider(): int
    {
        return $this->idProvider;
    }
    public function idTypeProvider(): int
    {
        return $this->idTypeProvider;
    }
}
