<?php

namespace App\Modules\ProviderTypeProvider\Application\Update;

use App\Modules\ProviderTypeProvider\Application\Update\ProviderTypeProviderUpdaterResponse;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;

final class ProviderTypeProviderUpdater
{
    public function __construct(private ProviderTypeProviderRepository $repository)
    {
    }

    public function __invoke(ProviderTypeProvider $ProviderTypeProvider): ProviderTypeProviderUpdaterResponse
    {
        return new ProviderTypeProviderUpdaterResponse($this->repository->update($ProviderTypeProvider));
    }
}
