<?php

namespace App\Modules\ProviderSanction\Application\Update;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\ProviderSanction\Domain\IdProviderSanction;
use App\Modules\ProviderSanction\Domain\ProviderSanctionDateEnd;
use App\Modules\ProviderSanction\Domain\ProviderSanctionDateStart;
use App\Modules\ProviderSanction\Domain\ProviderSanctionRemark;
use App\Modules\ProviderSanction\Domain\ProviderSanctionStatus;
use App\Modules\ProviderSanction\Domain\UpdateProviderSanction;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderSanctionUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private ProviderSanctionUpdater $updater)
    {
    }

    public function __invoke(ProviderSanctionUpdaterQuery $query): ProviderSanctionUpdaterResponse
    {
        $model = new UpdateProviderSanction(
            new IdProviderSanction($query->id()),
            new ProviderSanctionRemark($query->remark()),
            new ProviderSanctionDateStart($query->dateStart()),
            new ProviderSanctionDateEnd($query->dateEnd()),
            new ProviderSanctionStatus($query->status()),
            new IdProvider($query->idProvider()),
        );
        return $this->updater->__invoke($model);
    }
}
