<?php

namespace App\Modules\ProviderSanction\Application\Create;

use App\Modules\Provider\Domain\IdProvider;
use App\Modules\ProviderSanction\Domain\InsertProviderSanction;
use App\Modules\ProviderSanction\Domain\ProviderSanctionDateEnd;
use App\Modules\ProviderSanction\Domain\ProviderSanctionDateStart;
use App\Modules\ProviderSanction\Domain\ProviderSanctionRemark;
use App\Modules\ProviderSanction\Domain\ProviderSanctionStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderSanctionInserterQueryHandler implements QueryHandler
{
    public function __construct(private ProviderSanctionInserter $inserter)
    {
    }

    public function __invoke(ProviderSanctionInserterQuery $query): ProviderSanctionInserterResponse
    {
        $model = new InsertProviderSanction(
            new ProviderSanctionRemark($query->remark()),
            new ProviderSanctionDateStart($query->dateStart()),
            new ProviderSanctionDateEnd($query->dateEnd()),
            new ProviderSanctionStatus($query->status()),
            new IdProvider($query->idProvider()),
        );
        return $this->inserter->__invoke($model);
    }
}
