<?php

namespace App\Modules\PaxInformationPassenger\Infraestructure;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformationPassenger\Domain\IdPaxInformationPassenger;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRemaining;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRepository;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerStatus;
use App\Modules\PaxInformationPassenger\Domain\UpdatePaxInformationPassenger;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPaxInformationPassengerRepository implements PaxInformationPassengerRepository
{

    public function insert(
        PaxInformationPassengerRemaining $remaining,
        PaxInformationPassengerStatus $status,
        IdPaxInformation $idPaxInformation,
        IdPassenger $idPassenger
    ):array {
        return Requester::requestInsert(
            'CALL sp_pax_information_passenger_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $remaining->value(),
                $status->value(),
                $idPaxInformation->value(),
                $idPassenger->value()
            ]
        );
    }

    public function find(IdPaxInformation $idPaxInformation, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_pax_information_passenger_list(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $idPaxInformation->value(),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_THUMB"),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_LARGE"),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_THUMB"),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_LARGE"),
                $action
            ]
        );
    }

    public function index(IdPaxInformationPassenger $id)
    {
        return Requester::requestSelect(
            'CALL sp_pax_information_passenger_index(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $id->value(),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_THUMB"),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT1_LARGE"),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_THUMB"),
                config("var.PATH_PUBLIC") . config("var.PASSENGER_IMGDOCUMENT2_LARGE"),
            ]
        );
    }

    public function use(IdPaxInformationPassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_pax_information_passenger_use(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function update(UpdatePaxInformationPassenger $value)
    {
        return Requester::requestUpdate(
            'CALL sp_pax_information_passenger_update(?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function delete(IdPaxInformationPassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_pax_information_passenger_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
