<?php

namespace App\Modules\PaxInformationPassenger\Domain;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\PaxInformation\Domain\IdPaxInformation;

interface PaxInformationPassengerRepository
{

    public function insert(
        PaxInformationPassengerRemaining $remaining,
        PaxInformationPassengerStatus $status,
        IdPaxInformation $idPaxInformation,
        IdPassenger $idPassenger
    ):array;
    

    public function find(IdPaxInformation $idPaxInformation, string $action);

    public function index(IdPaxInformationPassenger $id);

    public function use(IdPaxInformationPassenger $id);

    public function update(UpdatePaxInformationPassenger $value);

    public function delete(IdPaxInformationPassenger $id);
}
