<?php

namespace App\Modules\PassengerReview\Application;

use App\Modules\Group\Application\GroupTokenDecrypter;
use App\Modules\Group\Application\GroupTokenFinder;
use App\Modules\Group\Domain\GroupToken;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\PassengerReview\Domain\PassengerReviewRepository;

class PassengerReviewFinderByGroup
{

    private PassengerReviewRepository $repository;

    public function __construct(PassengerReviewRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $idGroup, PassengerNoDocument $passengerNoDocument)
    {
        return $this->repository->passengerFindByGroup($idGroup, $passengerNoDocument);
    }
}
