<?php

namespace App\Modules\Passenger\Application\ReviewReport;

use App\Modules\Passenger\Domain\PassengerSearchWithReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class PassengerReviewReporter
{
    public function __construct(private PassengerSearchWithReviewRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $uploadedMediaStatus,
        $action
    ): PassengerReviewReportResponse {
        return new PassengerReviewReportResponse($this->repository->reviewReport(
            $dateStart,
            $dateEnd,
            $range,
            $uploadedMediaStatus,
            $action
        ));
    }
}
