<?php

namespace App\Modules\Passenger\Application\ExcelReviewReport;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class PassengerExcelReviewReportQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $dateEnd,
        private $range,
        private $action
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }
    public function dateEnd(): string
    {
        return $this->dateEnd;
    }
    public function range()
    {
        return $this->range;
    }
    public function action()
    {
        return $this->action;
    }
}
